import { RefObject } from '@mui/x-internals/types';
import { GridDataSourceCache } from "../../../models/gridDataSource.js";
import { CacheChunkManager, DataSourceRowsUpdateStrategy } from "./utils.js";
import type { GridDataSourceApi, GridDataSourceBaseOptions } from "./models.js";
import type { GridPrivateApiCommunity } from "../../../models/api/gridApiCommunity.js";
import type { DataGridProcessedProps } from "../../../models/props/DataGridProps.js";
import type { GridStrategyProcessor } from "../../core/strategyProcessing/index.js";
import type { GridEventListener } from "../../../models/events/index.js";
export declare const useGridDataSourceBase: <Api extends GridPrivateApiCommunity>(apiRef: RefObject<Api>, props: Pick<DataGridProcessedProps, "dataSource" | "dataSourceCache" | "onDataSourceError" | "pageSizeOptions" | "pagination" | "signature">, options?: GridDataSourceBaseOptions) => {
  api: {
    public: GridDataSourceApi;
  };
  debouncedFetchRows: ((parentId?: import("@mui/x-data-grid").GridRowId, params?: Partial<import("@mui/x-data-grid").GridGetRowsParams>) => void) & import("@mui/utils/debounce").Cancelable;
  strategyProcessor: {
    strategyName: DataSourceRowsUpdateStrategy;
    group: "dataSourceRowsUpdate";
    processor: GridStrategyProcessor<"dataSourceRowsUpdate">;
  };
  setStrategyAvailability: () => void;
  cacheChunkManager: CacheChunkManager;
  cache: GridDataSourceCache;
  events: {
    strategyAvailabilityChange: GridEventListener<"strategyAvailabilityChange">;
    sortModelChange: (params: unknown) => void;
    filterModelChange: (params: unknown) => void;
    paginationModelChange: (params: unknown) => void;
  };
};